#include "Element.h"

#include "Flaw.h"

#include <string.h>

namespace MM
{

const Element::Attribute Element::attribute_[] =
    {
    { "Dummy",      0.0       ,0.00, 0.00},  

    { "H",          1.007947  ,0.37, 1.20}, //fix
    //{ "H",          4.0  ,0.37, 1.20}, //fix
    //{ "H",          30.00  ,0.37, 1.20}, //fix

    { "He",         4.0026022 ,0.85, 1.18},
//fix    { "Li",         6.9412    ,0.68, 1.82},
    { "Li",         6.9412    ,0.00, 1.82},
    { "Be",         9.01218   ,0.90, 1.9 },
    { "B",          10.81     ,0.89, 2.08},
    { "C",          12.011    ,0.77, 1.7 },
    { "N",          14.0067   ,0.70, 1.55},
    { "O",          15.9994   ,0.66, 1.52},
    { "F",          18.998403 ,0.64, 1.47},
    { "Ne",         20.179    ,1.07, 1.54},
//fix    { "Na",         22.98977  ,1.54, 2.27},
    { "Na",         22.98977  ,0.00, 2.27},
    { "Mg",         24.305    ,1.36, 1.73},
    { "Al",         26.98154  ,1.18, 2.05},
    { "Si",         28.0855   ,1.17, 2.10},
    { "P",          30.97376  ,1.10, 1.80},
    { "S",          32.06     ,1.04, 1.80},
    { "Cl",         35.453    ,0.99, 1.75},
    { "Ar",         39.948    ,1.20, 1.88},
//fix    { "K",          39.0983   ,2.03, 2.75},
    { "K",          39.0983   ,0.00, 2.75},
    { "Ca",         40.08     ,1.74, 1.97},
    { "Sc",         44.9559   ,1.44, 1.75},
    { "Ti",         47.90     ,1.32, 1.61},
    { "V",          50.9414   ,1.22, 1.47},
    { "Cr",         51.996    ,1.18, 1.40},
    { "Mn",         54.9380   ,1.17, 1.53},
    { "Fe",         55.847    ,1.17, 1.39},
    { "Co",         58.9332   ,1.16, 1.41},
    { "Ni",         58.70     ,1.15, 1.40},
    { "Cu",         63.546    ,1.17, 1.43 },
    { "Zn",         65.38     ,1.25, 1.39},
    { "Ga",         69.72     ,1.26, 1.21},
    { "Ge",         72.59     ,1.22, 1.18 },
    { "As",         74.9216   ,1.21, 1.85},
    { "Se",         78.96     ,1.17, 1.9 },
    { "Br",         79.904    ,1.14, 1.85},
    { "Kr",         83.80     ,1.10, 2.02},
//fix    { "Rb",         85.4678   ,2.16, 2.06},
    { "Rb",         85.4678   ,0.00, 2.06},
    { "Sr",         87.62     ,1.91, 1.82},
    { "Y",          88.9059   ,1.62, 1.67},
    { "Zr",         91.22     ,1.45, 1.56},
    { "Nb",         92.9064   ,1.34, 1.58},
    { "Mo",         95.94     ,1.30, 1.53},
    { "Tc",         98.9062   ,1.27, 1.50},
    { "Ru",         101.07    ,1.25, 1.48},
    { "Rh",         102.9055  ,1.25, 1.46},
    { "Pd",         106.4     ,1.28, 1.63},
    { "Ag",         107.8682  ,1.34, 1.72},
    { "Cd",         112.41    ,1.48, 1.58},
    { "In",         114.82    ,1.44, 1.93},
    { "Sn",         118.69    ,1.40, 2.17},
    { "Sb",         121.75    ,1.41, 2.2 },
    { "Te",         127.60    ,1.37, 2.06},
    { "I",          126.9045  ,1.33, 1.98},
    { "Xe",         131.30    ,1.30, 2.16},
//fix    { "Cs",         132.9054  ,2.35, 2.26},
    { "Cs",         132.9054  ,0.00, 2.26},
    { "Ba",         137.33    ,1.98, 1.85},
    { "La",         138.9055  ,1.69, 1.76},
    { "Ce",         140.12    ,1.83, 1.78},
    { "Pr",         140.9077  ,1.82, 1.80},
    { "Nd",         144.24    ,1.81, 1.79},
    { "Pm",         145       ,1.80, 1.77},
    { "Sm",         150.4     ,1.80, 1.76},
    { "Eu",         151.96    ,1.99, 1.75},
    { "Gd",         157.25    ,1.79, 1.68},
    { "Tb",         158.9254  ,1.76, 1.73},
    { "Dy",         162.50    ,1.75, 1.71},
    { "Ho",         164.9304  ,1.74, 1.70},
    { "Er",         167.26    ,1.73, 1.70},
    { "Tm",         168.9342  ,1.72, 1.69},
    { "Yb",         173.04    ,1.94, 1.68},
    { "Lu",         174.967   ,1.72, 1.82},
    { "Hf",         178.49    ,1.44, 1.57},
    { "Ta",         180.9479  ,1.34, 1.59},
    { "W",          183.85    ,1.30, 1.53},
    { "Re",         186.207   ,1.28, 1.48},
    { "Os",         190.2     ,1.26, 1.56},
    { "Ir",         192.22    ,1.27, 1.42},
    { "Pt",         195.09    ,1.30, 1.38},
    { "Au",         196.9665  ,1.34, 1.65},
    { "Hg",         200.59    ,1.49, 1.35},
    { "Tl",         204.37    ,1.48, 2.17},
    { "Pb",         207.2     ,1.48, 2.15},
    { "Bi",         208.9804  ,1.45, 2.19},
    { "Po",         209       ,1.46, 2.35},
    { "At",         210       ,1.45, 2.38},
    { "Rn",         222       ,1.40, 2.38},
    { "Fr",         223       ,2.00, 2.45},
    { "Ra",         226.0254  ,1.90, 1.84},
    { "Ac",         227       ,1.88, 1.74},
    { "Th",         232.0381  ,1.79, 1.70},
    { "Pa",         231.0359  ,1.61, 1.71},
    { "U",          238.029   ,1.58, 1.86},
    { "Np",         237.0482  ,1.55, 1.71},
    { "Pu",         244       ,1.53, 1.71},
    { "Am",         243       ,1.66, 1.69},
    { "Cm",         247       ,1.80, 1.66},
    { "Bk",         247       ,1.76, 1.67},
    { "Cf",         251       ,1.75, 1.66},
    { "Es",         254       ,1.72, 1.65},
    { "Fm",         257       ,1.71, 1.64},
    { "Md",         258       ,1.69, 1.64},
    { "No",         255       ,1.68, 1.64},
    { "Lr",         256       ,1.70, 1.62},
    { "Ku",         261       ,1.7 , 1.6 },
    { "Ns",         261       ,1.7 , 1.6 },
    { "Lp",         0         ,0.0 , 0.0 },
    { "Unknown",    1         ,0.77, 1.7 },
    { "Any",        0         ,0.77, 1.7 }, 
    { "Bead",       1000      ,1.5  ,3.0 },
    { "One",        1         ,1.0  ,1.0 }
   };


//................................

Element::Element()
: number_(Unknown)
{
}

Element::~Element()
{
    number_ = Unknown;
}

Element::Element( const char * str )
{
    if      ( * str == 'H' && str[ 1 ] == '\0' )
    {
        number_ = ( E_Number )1;
        return;
    }
    else if ( * str == 'C' && str[ 1 ] == '\0' )
    {
        number_ = ( E_Number )6;
        return;
    }
    else if ( * str == 'N' && str[ 1 ] == '\0' )
    {
        number_ = ( E_Number )7;
        return;
    }
    else if ( * str == 'O' && str[ 1 ] == '\0' )
    {
        number_ = ( E_Number )8;
        return;
    }
    else
        for( int i = 0;  i < MAX_ELEMENT;  i++ )
            if( !strcmp( str, attribute_[ i ].name_ ) )
            {
                number_ = ( E_Number )i;
                return;
            }
    FLAW( Text( "\"" ) + str + "\" - no such element" );
}

bool Element::
is (const char * str)
{
    if      ( * str == 'H' && str[ 1 ] == '\0' )
    {
        return true;
    }
    else if ( * str == 'C' && str[ 1 ] == '\0' )
    {
        return true;
    }
    else if ( * str == 'N' && str[ 1 ] == '\0' )
    {
        return true;
    }
    else if ( * str == 'O' && str[ 1 ] == '\0' )
    {
        return true;
    }
    else
        for( int i = 0;  i < MAX_ELEMENT;  i++ )
            if( !strcmp( str, attribute_[ i ].name_ ) )
            {
                return true;
            }

    return false;
}

const char * Element::
c_str() const
{
    return attribute_[ number_ ].name_;
}

double Element::
mass() const
{
    return attribute_[ number_ ].mass_;
}

double Element::
covalent_radius() const
{
    return attribute_[ number_ ].covalent_radius_;
}

double Element::
van_der_Waals_radius() const
{
    return attribute_[ number_ ].van_der_Waals_radius_;
}

const Element & Element::
operator = ( int r )
{
    number_ = ( E_Number )r;
    return * this;
}

bool Element::
operator == ( const Element & r ) const
{
    return number_ == r.number_;
}

bool Element::
operator != ( const Element & r ) const
{
    return number_ != r.number_;
}

}//MM



