#ifndef ELEMENT_H
#define ELEMENT_H

namespace MM
{

const int MAX_ELEMENT = 111;

class Element       //fix
{
public:

    enum E_Number
    {
        Dummy = 0, H,  He, Li, Be, B,  C,  N,  O,  F, 
               Ne, Na, Mg, Al, Si, P,  S,  Cl, Ar, K, 
               Ca, Sc, Ti, V,  Cr, Mn, Fe, Co, Ni, Cu, 
               Zn, Ga, Ge, As, Se, Br, Kr, Rb, Sr, Y, 
               Zr, Nb, Mo, Tc, Ru, Rh, Pd, Ag, Cd, In, 
               Sn, Sb, Te, I,  Xe, Cs, Ba, La, Ce, Pr, 
               Nd, Pm, Sm, Eu, Gd, Tb, Dy, Ho, Er, Tm, 
               Yb, Lu, Hf, Ta, W,  Re, Os, Ir, Pt, Au, 
               Hg, Tl, Pb, Bi, Po, At, Rn, Fr, Ra, Ac, 
               Th, Pa, U,  Np, Pu, Am, Cm, Bk, Cf, Es, 
               Fm, Md, No, Lr, Ku, Ns, Lp, Unknown, Any, Bead, 
               One
    };

    static int      count ()                    {return MAX_ELEMENT;}

                    operator int() const        {return number_;}
    int             number() const              {return number_;}

    static bool     is (const char * str);

    const char *    c_str() const;
    double          mass() const;
    double          covalent_radius() const;
    double          van_der_Waals_radius () const;

    Element();
    ~Element();

    Element (int number) : number_( ( E_Number )number ) { }
    Element (const char *);

    const Element & operator =  ( int r );
    bool            operator ==(const Element & r ) const;
    bool            operator !=(const Element & r ) const;

private:
    E_Number        number_;

    struct Attribute
    {
        char    name_[8];
        double  mass_;
        double  covalent_radius_;
        double  van_der_Waals_radius_;
    };

    static const Attribute attribute_[MAX_ELEMENT];
};

}//MM

#endif //ELEMENT_H
