#include "Hyperchem_attributes.h"

#include "Atom.h"
#include "Bond.h"

namespace MM
{

bool Hyperchem_attributes::invariant() const
{
    return //number_ >= 0 &&
        name_.size() > 0 && type_.size() > 0 && flags_.size() > 0;
}

Hyperchem_attributes::Hyperchem_attributes (Atom & atom)
: atom_(atom), number_( -1 ), name_("-"), type_("**"), flags_("-")
{
}

const Order Hyperchem_attributes::
bond_order (int i) const
{
    INVARIANT;
    return atom_.bond (i).order();
    //return Order( Order::Single );
} 

void Hyperchem_attributes::set_flags ( const Text & flags  ) {flags_ = flags;}
void Hyperchem_attributes::set_type  ( const Text & type   ) {type_  = type;}
void Hyperchem_attributes::set_name  ( const Text & name   ) {name_  = name;}
void Hyperchem_attributes::set_number( int          number ) const {number_= number;}

}//MM
