#ifndef HYPERCHEM_ATTRIBUTES_H
#define HYPERCHEM_ATTRIBUTES_H

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef ORDER_H
#include "Order.h"
#endif

namespace MM
{
class Atom;

class Hyperchem_attributes :  protected DbC
{
    virtual bool invariant() const;

    Atom &                  atom_;

    mutable int             number_;
    Text                    name_;
    Text                    type_;
    Text                    flags_;

public:
    explicit Hyperchem_attributes (Atom & atom);

    virtual int             number        () const
    {
        INVARIANT;
        return number_;
    }
    virtual const Text &    name          () const
    {
        INVARIANT;
        return name_;
    }
    virtual const Text &    type          () const
    {
        INVARIANT;
        return type_;
    }
    virtual const Text &    flags         () const
    {
        INVARIANT;
        return flags_;
    }
//    virtual const Order     bond_order( int neighbor ) const
    virtual const Order     bond_order (int i) const;

    virtual void            set_number( int          number ) const;
    virtual void            set_name  ( const Text & name   );
    virtual void            set_type  ( const Text & type   );
    virtual void            set_flags ( const Text & flags  );
};

}//MM

#endif //HYPERCHEM_ATTRIBUTES_H


