#ifndef MATERIAL_POINT_H
#define MATERIAL_POINT_H

namespace MM
{
class Point_3D;
class Vector_3D;

class Material_point
{
public:
    virtual ~Material_point (){}   //fix

    virtual double              mass    () const =0;
    virtual double              ff_mass () const =0;
    virtual Point_3D const &    position() const =0;
    virtual void                set_position (Point_3D const & new_position,
                                              bool        silent = false) =0;
    virtual void                set_position_silent
                                        (double x, double y, double z) =0;
    virtual void                move   (Vector_3D const & movement,
                                        bool              silent = false) =0;

    //virtual void                rotate (Vector_3D const& around, double teta)=0;
    virtual void                rotate (Vector_3D const& around,
                                        Point_3D  const& point,
                                        double teta) =0;

    virtual void                update () =0;
};

}//MM

#endif //MATERIAL_POINT_H
