#ifndef OPENRM_ATOM_H
#define OPENRM_ATOM_H

#ifndef VISUAL_ATOM_H
#include "Visual_atom.h"
#endif

class View_atom_type;

extern "C" 
{
struct RMprimitive;
struct RMnode;
}

class OpenRMWidget;

namespace MM
{

class OpenRM_atom : public Visual_atom
{
    Atom_kit &              kit_;
    RMnode *                atom_node_;
    RMnode *                parent_node_;
    OpenRMWidget *          rm_widget_;
    mutable bool            show_flag_;

    Visual_style            style_;

    RMnode *                CPK_node_;
    RMprimitive *           sphere_;

public:
    OpenRM_atom (Atom_kit & kit, RMnode *parent_node, OpenRMWidget *rm_widget);
    ~OpenRM_atom();
    virtual Visual_atom *   clone (Atom_kit & kit) const;

    Atom_kit &              kit ();
    Atom_kit const &        kit () const;

    OpenRMWidget *          rm_widget ()    {return rm_widget_;}

//    bool                    is_shown ()         {return show_flag_;}
    void                    show (bool on = true);
    void                    renew_view ();
    void                    renew_coordinates ();
    void                    renew_model ();
    void                    renew ();

    //void                    update () const;
    ///void                    update_view_type   (View_atom_type & type);
    //void                    update_coordinates (double x, double y, double z);
    //virtual void            get_color          (int *R, int *G, int *B);
    void                    set_color          (int R,  int G,  int B);
    void                    set_level_of_details (int lod) ;
    void                    set_style (Visual_style const & );

protected:
    void                    set_element ();
};

}//MM

#endif //OPENRM_ATOM_H
