#ifndef POINT_3D_H
#define POINT_3D_H

//#ifndef PARAMETER_H
//#include "Parameter.h"
//#endif

namespace MM
{
class Vector_3D;

class Point_3D //: public Parameter
{
public:    
    virtual             ~Point_3D();

    virtual void        difference (Point_3D const & p,
                                    Vector_3D * result) const =0;

    virtual double      x() const = 0;
    virtual double      y() const = 0;
    virtual double      z() const = 0;

    virtual void        set_x(double) = 0;
    virtual void        set_y(double) = 0;
    virtual void        set_z(double) = 0;
    virtual void        set_zero() = 0;

    virtual void        operator += (Vector_3D const & v) =0;
    virtual void        operator -= (Vector_3D const & v) =0;

    virtual void        add_scaled (double scale,
                                    Vector_3D const& v) =0;

    virtual double      distance   (Point_3D const & p) const =0;
    virtual double      distance_2 (Point_3D const & p) const =0;
    virtual void        affine     (Point_3D const & p, double t) =0;
    
    //fix virtual void        gomogeneous (double *result);
    //fix virtual void        get_tuple (double *result);

//    virtual void        origin     (Point_3D & result) const =0;
};

}//MM

#endif //POINT_3D_H
