#ifndef VECTOR_3D_H
#define VECTOR_3D_H

//#ifndef PARAMETER_H
//#include "Parameter.h"
//#endif

namespace MM
{

class Vector_3D //: public Parameter
{
public:
    virtual ~Vector_3D() { }//fix

    virtual double          x() const =0;
    virtual double          y() const =0;
    virtual double          z() const =0;
    virtual void            set_x(double x ) =0;
    virtual void            set_y(double y ) =0;
    virtual void            set_z(double z ) =0;
    virtual void            clear ()         =0;

    virtual Vector_3D &     negate () =0;
    virtual Vector_3D &     norm   () =0;

    //virtual void            operator =  (Vector_3D const & v) =0;
    virtual void            operator += (Vector_3D const & v) =0;
    virtual void            operator -= (Vector_3D const & v) =0;
    virtual void            operator *= (double v) =0;
    virtual void            add_scaled (double scale,
                                        Vector_3D const& v) =0;

    virtual double          length  () const =0;
    virtual double          length_2() const =0;
    virtual double          dot     (Vector_3D const & v) const =0;
    virtual void            cross   (Vector_3D const & v) =0;
    virtual void            cross   (Vector_3D const & v,
                                     Vector_3D * result) const =0;

    virtual void            affine (Vector_3D const & p, double t) =0;
    //fix virtual void        gomogeneous (double *result);
    virtual int             dimensions () const = 0;
};

}//MM

#endif //VECTOR_3D_H
