#include "Vector_3D_impl.h"

//#include "Linear_combination.h"
//#include "Linear_combination_handler.h"

#include <math.h>

namespace MM
{

void Vector_3D_impl::
add_scaled (double scale, Vector_3D const& v)
{
    x_ += v.x() * scale;
    y_ += v.y() * scale;
    z_ += v.z() * scale;
}

double Vector_3D_impl::
length() const
{
    return sqrt (x_*x_ + y_*y_ + z_*z_);
}

double Vector_3D_impl::
dot (Vector_3D const & v) const
{
    return x_ * v.x() + y_ * v.y() + z_ * v.z();
}

void Vector_3D_impl::
cross (Vector_3D const & v)
{
    double x_tmp = y_ * v.z() - z_ * v.y();
    double y_tmp = z_ * v.x() - x_ * v.z();
    //double z_tmp = x_ * v.y() - y_ * v.x();
    z_ = x_ * v.y() - y_ * v.x();
    x_ = x_tmp;
    y_ = y_tmp;
    //z_ = z_tmp;
}

void Vector_3D_impl::
cross (Vector_3D const & v, Vector_3D * result) const
{
    result->set_x (y_ * v.z() - z_ * v.y());
    result->set_y (z_ * v.x() - x_ * v.z());
    result->set_z (x_ * v.y() - y_ * v.x());
}

void Vector_3D_impl::
affine (Vector_3D const & v, double t)
{
    x_ = (1 - t) * x_ + t * v.x();
    y_ = (1 - t) * y_ + t * v.y();
    z_ = (1 - t) * z_ + t * v.z();
}
/*
void Vector_3D_impl::
get (double * values) const
{
    *values++ = x_;
    *values++ = y_;
    *values++ = z_;
}

void Vector_3D_impl::
set (double const* new_values)
{
    x_ = *new_values++;
    y_ = *new_values++;
    z_ = *new_values++;
}

void Vector_3D_impl::
add (double const* values)
{
    x_ += *values++;
    y_ += *values++;
    z_ += *values++;
}

void Vector_3D_impl::
add_scaled (double scale, double const* values)
{
    x_ += *values++ * scale;
    y_ += *values++ * scale;
    z_ += *values++ * scale;
}

void Vector_3D_impl::
multiply (double value)
{
    x_ *= value;
    y_ *= value;
    z_ *= value;
}

Linear_combination_handler Vector_3D_impl::
linear_combination (double a)
{
    return Linear_combination_handler (new Linear_combination (a));
}
//*/
}//MM







