#ifndef VISUAL_ATOM_H
#define VISUAL_ATOM_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef VISUAL_STYLE_H
#include "Visual_style.h"
#endif

class View_atom_type;

namespace MM
{
class Atom_kit;

class Visual_atom : protected DbC
{
public:
    virtual Atom_kit &          kit () =0;
    virtual Atom_kit const &    kit () const =0;

    virtual void                show (bool on = true) =0;

    virtual Visual_atom *   clone (Atom_kit & kit) const=0;

    ///virtual void            update_view_type   (View_atom_type & type)=0;
//    virtual void            update_coordinates (double x, double y, double z)=0;
//    virtual void            get_color          (int *R, int *G, int *B)=0;
    virtual void            set_color          (int R,  int G,  int B)=0;
    virtual void            set_level_of_details (int lod) =0;

    virtual void            renew_view () =0;
    virtual void            renew_coordinates () =0;
    virtual void            renew_model () =0;
    virtual void            renew () =0;
    virtual void            set_style (Visual_style const &) =0;

//    virtual bool            in (Visual_model const &) const =0;

};

}//MM

#endif //VISUAL_ATOM_H
