#include "Visual_atom_composite.h"

#include "Atom_kit.h"

namespace MM
{
Atom_kit & Visual_atom_composite::
kit ()
{
    return kit_;
}

Atom_kit const & Visual_atom_composite::
kit () const
{
    return kit_;
}


Visual_atom * Visual_atom_composite::
clone (Atom_kit & kit) const
{
    Visual_atom_composite *result = new Visual_atom_composite (kit);

    for (int i=0;  i<count();  ++i)
        result->adopt (atom_[i].clone (kit));

    return result;
}

void Visual_atom_composite::
adopt (Visual_atom *adoptee)
{
    atom_.push_back (adoptee);
}

void Visual_atom_composite::
show (bool on)
{
    for (int i=0;  i<count();  ++i)
        atom_[i].show (on);
}

//void Visual_atom_composite::
//update_view_type   (View_atom_type & type)
//{
//    for (int i=0;  i<count();  ++i)
//    {
//        //atom_[i].update_view_type (type);
//        Visual_atom & current = atom_[i];
//        current.update_view_type (type);
//    }
//}

/*void Visual_atom_composite::
update_coordinates (double x, double y, double z)
{
    for (int i=0;  i<count();  ++i)
        atom_[i].update_coordinates (x, y, z);
} //*/

/*void Visual_atom_composite::
get_color (int *R, int *G, int *B)
{
    if (count() > 0)
        atom_[0].get_color (R, G, B);
}//*/

void Visual_atom_composite::
set_color (int R, int G, int B)
{
    for (int i=0;  i<count();  ++i)
        atom_[i].set_color (R, G, B);
}

void Visual_atom_composite::
set_level_of_details (int lod)
{
    for (int i=0;  i<count();  ++i)
        atom_[i].set_level_of_details (lod);
}//*/

void Visual_atom_composite::
renew_view ()
{
    for (int i=0;  i<count();  ++i)
        atom_[i].renew_view ();
}

void Visual_atom_composite::
renew_coordinates ()
{
    for (int i=0;  i<count();  ++i)
        atom_[i].renew_coordinates ();
}

void Visual_atom_composite::
renew_model ()
{
    for (int i=0;  i<count();  ++i)
        atom_[i].renew_model ();
}

void Visual_atom_composite::
renew ()
{
    for (int i=0;  i<count();  ++i)
        atom_[i].renew ();
}

void Visual_atom_composite::
set_style (Visual_style const & style)
{
    for (int i=0;  i<count();  ++i)
        atom_[i].set_style (style);
}

}//MM
