#ifndef VISUAL_ATOM_COMPOSITE_H
#define VISUAL_ATOM_COMPOSITE_H

#ifndef VISUAL_ATOM_H
#include "Visual_atom.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

namespace MM
{

class Visual_atom_composite : public Visual_atom
{
    Atom_kit &                      kit_;
    Array_of_own <Visual_atom>      atom_;

public:
    explicit Visual_atom_composite (Atom_kit & kit) : kit_(kit) {}
    Visual_atom *       clone (Atom_kit & kit) const;

    Atom_kit &          kit ();
    Atom_kit const &    kit () const;

    int                 count () const                  {return atom_.size();}
    Visual_atom &       view (int i)                    {return atom_[i];}
    Visual_atom const & view (int i) const              {return atom_[i];}
    void                adopt (Visual_atom *adoptee);

    void                show (bool on = true);

    ///void                update_view_type   (View_atom_type & type);
    //void                update_coordinates (double x, double y, double z);
    //void                get_color          (int *R, int *G, int *B);
    void                set_color          (int R, int G, int B);
    void                set_level_of_details (int lod);

    void                renew_view ();
    void                renew_coordinates ();
    void                renew_model ();
    void                renew ();
    void                set_style (Visual_style const & );
};

}//MM

#endif //VISUAL_ATOM_COMPOSITE_H
