#ifndef VISUAL_STYLE_H
#define VISUAL_STYLE_H

namespace MM
{
class Atom;
class Bond;

class Visual_style
{
public:
    enum Type
    {
        CPK,                // CPK - Corey-Pauling-Kultun
        stick,
        ball_and_stick,
        wireframe,
        wireframe_CPK
        //,invisible
    };

protected:
    Type                    type_;
    bool                    special_color_;
    float                   r_, g_, b_, a_;

public:
    Visual_style ();
    Visual_style (Type type);

    //struct Color {float r, g, b, a;};

    Type    type () const {return type_;}

    void    color (Atom const &, 
                   float & r, float & g, float & b, float & a) const;

    void    color (Bond const &, 
                   float & r, float & g, float & b, float & a) const;

    void    color (Bond const &,
                   float & r0, float & g0, float & b0, float & a0,
                   float & r1, float & g1, float & b1, float & a1) const;

    float   radius  (Atom const &) const;

    //bool operator == (Visual_style style) const {return type_ == style.type_;}

    bool    has_special_color () const      {return special_color_;}
    bool    set_special_color (bool on)     {special_color_= on; 
                                             return special_color_;}
    bool    set_special_color (float r, float g, float b, 
                               float a = 1.F, bool on=true);
};


}//MM

#endif //VISUAL_STYLE_H
