#ifndef ARBITRARY_ATOM_GROUP_H
#define ARBITRARY_ATOM_GROUP_H

#ifndef ATOM_GROUP_H
#include "Atom_group.h"
#endif

#ifndef EXPANDED_ATOM_GROUP_H
#include "Expanded_atom_group.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{

class Arbitrary_atom_group : public Expanded_atom_group
{
    Array_of_ref <Atom>   group_;

public:
    int             atom_count () const {return group_.size();}
    Atom &          atom (int i)        {return group_[i];}
    const Atom &    atom (int i) const  {return group_[i];}
    void            add (Atom &atom)    {group_.push_back(atom);}
    void            erase ()            {group_.clear();}
};

}//MM

#endif //ARBITRARY_ATOM_GROUP_H
