#ifndef ARBITRARY_BOND_GROUP_H
#define ARBITRARY_BOND_GROUP_H

#ifndef BOND_GROUP_H
#include "Bond_group.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{

class Arbitrary_bond_group : public Bond_group
{
    Array_of_ref <Bond>     group_;

public:
    int             bond_count () const     {return group_.size();} 
    Bond &          bond (int i)            {return group_[i];}
    const Bond &    bond (int i) const      {return group_[i];}
    void            add (Bond & bond)       {group_.push_back (bond);}
};

}//MM

#endif //ARBITRARY_BOND_GROUP_H
