#ifndef ARBITRARY_MOLECULAR_GROUP_H
#define ARBITRARY_MOLECULAR_GROUP_H

#ifndef MOLECULAR_GROUP_H
#include "Molecular_group.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{

class Arbitrary_molecular_group : public Molecular_group
{
    Array_of_ref <Molecule>     group_;

public:
    int                 molecule_count () const     {return group_.size();}
    Molecule &          molecule (int i)            {return group_[i];}
    const Molecule &    molecule (int i) const      {return group_[i];}
    void                add (Molecule & mol)        {group_.push_back (mol);}
    void                clear ()                    {group_.clear ();}
};

}//MM

#endif //ARBITRARY_MOLECULAR_GROUP_H
