//
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef BOND_H
#define BOND_H

#ifndef ATOM_GROUP_H
#include "Atom_group.h"
#endif

#ifndef ORDER_H
#include "Order.h"
#endif

#ifndef LIVING_FRAME_H
#include "Living_frame.h"
#endif

namespace MM
{
class ID;
class Bond_kit;
//class Text;

class Bond : public Living_frame, public Atom_group
{
public:    
    virtual Bond *                  clone () const = 0;   //for prototype
    virtual Bond *                  clone (Atom & atom1,           //fix remove
                                           Atom & atom2,
                                           const Order & order) const =0;
//                                   Order & order) const =0;
                                   //const Order & order = Order());
    //virtual void                    release () =0;

    virtual Bond_kit &              kit () =0;
    virtual const Bond_kit &        kit () const =0;

    virtual ID const &              id()    const = 0;
    virtual Order                   order() const = 0;
    virtual void                    set_order( Order   ) = 0;
    virtual bool                    is_backbone () const = 0;
};

}//MM

#endif //BOND_H
