#include "Bond_kit.h"

#include "Bond.h"
#include "Atom.h"
#include "Atom_kit.h"

#ifdef MM_WIN32
#pragma warning (disable : 4355)
#endif

namespace MM
{

Bond_kit::
Bond_kit (Bond & bond)
:
    bond_       (bond),
    visual_     (*this)/*,
    picked_     (false),
    selected_   (false),
    illusory_   (false),
    frozen_     (false)*/
{
}

bool Bond_kit::
is_picked () const
{
    bool result = true;
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit const & atom = bond().atom(i).kit();
        result &= atom.is_picked();
    }

    return result;
}

bool Bond_kit::
is_selected () const
{
    bool result = true;
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit const & atom = bond().atom(i).kit();
        result &= atom.is_selected();
    }

    return result;
}

////fix
//void Bond_kit::
//pick (bool on)
//{
//    int  count  = bond().atom_count();
//
//    for (int i=0;  i<count; ++i)
//    {
//        Atom_kit & atom = bond().atom(i).kit();
//        atom.pick (on);
//    }
//
//    visual().renew_view ();
//}

void Bond_kit::
select (bool on)
{
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit & atom = bond().atom(i).kit();
        atom.select (on);
    }

    visual().renew_view ();
}


bool Bond_kit::
is_illusory () const
{
    bool result = true;
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit const & atom = bond().atom(i).kit();
        result &= atom.is_illusory();
    }

    return result;
}

void Bond_kit::
set_illusory (bool on)
{
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit & atom = bond().atom(i).kit();
        atom.set_illusory (on);
    }

    visual().renew_view ();
}

bool Bond_kit::
was_frozen  () const
{
    bool result = true;
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit const & atom = bond().atom(i).kit();
        result &= atom.was_frozen();
    }

    return result;
}

void Bond_kit::
freeze (bool on)
{
    int  count  = bond().atom_count();

    for (int i=0;  i<count; ++i)
    {
        Atom_kit & atom = bond().atom(i).kit();
        atom.freeze (on);
    }

    visual().renew_view ();
}

void Bond_kit::
add_visual (Visual_bond *adoptee)
{
    visual_.adopt (adoptee);
}

}//MM
