#ifndef BOND_KIT_H
#define BOND_KIT_H

#ifndef BOND_CACHE_H
#include "Bond_cache.h"
#endif

#ifndef FLAG_H
#include "Flag.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef VISUAL_BOND_COMPOSITE_H
#include "Visual_bond_composite.h"
#endif

#ifndef SELECTABLE_H
#include "Selectable.h"
#endif

namespace MM
{

class Bond_kit : public Selectable
{
    Bond &                  bond_;
    Text                    comment_;
    Visual_bond_composite   visual_;
    //bool                    picked_;
    //bool                    selected_;
    //bool                    illusory_;
    //bool                    frozen_;

    friend class Selector;
    void                    select (bool on = true);

public:
    explicit Bond_kit (Bond & bond);

    Bond &                  bond ()                         {return  bond_;}
    Bond const &            bond () const                   {return  bond_;}

    Text const &            comment_line () const           {return comment_;}
    void                    set_comment_line (Text const& v){comment_ = v;}

    bool                    is_picked () const;
    //void                    pick   (bool on = true);

    bool                    is_selected () const;

    bool                            is_illusory () const;
    void                            set_illusory (bool on = true);

    bool                            was_frozen  () const;
    void                            freeze (bool on = true);

    // ChemCon //////////////////////////////////////////////////////////////
    enum   //fix
    {
        already_used = 1, mark_1_2 = 2, mark_1_3 = 4, mark_1_4 = 8,
        hetero = 16, has_improper_torsion = 32, united = 64, selected = 128,
        coords_was_changed = 256, already_calculated = 512, missed = 1024
    };

    Bond_cache *                    cache___;

    Visual_bond_composite &         visual()                {return visual_;}
    Visual_bond_composite const &   visual() const          {return visual_;}
    //bool                    has_visual() const  {}
    void                            add_visual (Visual_bond *adoptee);
};

}//MM

#endif //BOND_KIT_H
