#include "Branch.h"

#include "Branch_iterator.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "Molecule.h"

namespace MM
{

Branch::
Branch (Atom & root_atom, Atom & outside_atom)
:
    it_(root_atom, outside_atom),
    whole_molecule_(false)
{
    for (;  it_.is_valid();  it_.next())
        add (it_.current());

    for (int i=0;  i<atom_count();  ++i)
         atom(i).kit().flag().clear (Atom_kit::molecular_mark);
    outside_atom.kit().flag().clear (Atom_kit::molecular_mark);

    //fix     in_molecule * to . + class Void_molecule with detect molecules
    if (outside_atom.bound_count() != 1 &&
        root_atom.kit().in_molecule().atom_count() == atom_count() + 1)
    {
        add (outside_atom);
        whole_molecule_ = true;
    }
}

}//MM
