#ifndef DEFAULT_BOND_H
#define DEFAULT_BOND_H

#ifndef BOND_H
#include "Bond.h"
#endif

#ifndef BOND_KIT_H
#include "Bond_kit.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

#ifndef ORDER_H
#include "Order.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef ID_H
#include "ID.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{
class Prototype;

class Default_bond : public Bond
{
    Bond_kit                kit_;
    //Text                    id_;

    Order                   order_;
    Own <ID>                id_;
    Array_of_ref <Atom>     atoms_;


public:
    Default_bond (Prototype &);                             //fix remove
    Default_bond (Atom & atom1, Atom & atom2, const Order & order = Order() );

    virtual Bond *          clone () const;   //for prototype
    virtual Bond *          clone (Atom & atom1,
                                   Atom & atom2,
//                                 const Order & order) const;
                                   const Order & order) const;
                                   //const Order & order = Order());
    //virtual void                    release ();
    virtual                 ~Default_bond();

    virtual Bond_kit &              kit ()       {return kit_;}
    virtual const Bond_kit &        kit () const {return kit_;}

    virtual ID const &      id   () const        {return id_();}
    virtual Order           order() const;
    virtual void            set_order( Order   );
    virtual bool            is_backbone () const;

    // Atom_group
    virtual int             atom_count () const     {return atoms_.size();}
    virtual Atom &          atom (int i)            {return atoms_[i];}
    virtual const Atom &    atom (int i) const      {return atoms_[i];}
//    virtual void            add_atom ( Atom  & );
//    virtual void            add_atoms( Collection_of < Atom > &  );
//    virtual void            set_atoms( Collection_of < Atom > &  );
};

}//MM

#endif //DEFAULT_BOND_H
