#ifndef HYDROGEN_ATOMS_H
#define HYDROGEN_ATOMS_H

#ifndef ATOM_GROUP_H
#include "Atom_group.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{

class Hydrogen_atoms :public Atom_group
{
    Array_of_ref <Atom>   group_;

public:
    explicit Hydrogen_atoms (Atom_group & group)
    {
        for (int i=0;  i<group.atom_count();  ++i)
        {
            Atom & current_atom = group.atom(i);
    
            if (current_atom.element().number() == Element::H)
                group_.push_back (current_atom);
        }
    }

    int             atom_count () const {return group_.size();}
    Atom &          atom (int i)        {return group_[i];}
    const Atom &    atom (int i) const  {return group_[i];}
};

}//MM

#endif //HYDROGEN_ATOMS_H
