#include "Molecular_depth_iterator.h"

#include "Atom.h"
#include "Atom_kit.h"

namespace MM
{

Molecular_depth_iterator::
Molecular_depth_iterator (Atom & root_atom)
{
    root_atom.kit().flag().set (Atom_kit::molecular_mark);
    stack_.push (&root_atom);
}

Atom & Molecular_depth_iterator::
current ()
{
    return *stack_.top ();
}

const Atom & Molecular_depth_iterator::
current () const
{
    return *stack_.top ();
}

void Molecular_depth_iterator::
next()
{
    Atom *current_atom = stack_.top ();
    stack_.pop ();
    find_neighbours (current_atom);
}

bool Molecular_depth_iterator::
is_valid ()
{
    return ! stack_.empty ();
}

void Molecular_depth_iterator::
find_neighbours (Atom * current_atom)
{
    int count = current_atom->bound_count ();
    for (int i=0;  i<count;  ++i)
    {
        Atom *neighbour = & current_atom->bound (i);
        if (neighbour->kit().flag().is_not (Atom_kit::molecular_mark))
        {
            neighbour->kit().flag().set (Atom_kit::molecular_mark);
            stack_.push (neighbour);
        }
    }
}

}//MM
