#ifndef MOLECULAR_SEQUENCE_IMPL_H
#define MOLECULAR_SEQUENCE_IMPL_H

#ifndef MOLECULAR_SEQUENCE_H
#include "Molecular_sequence.h"
#endif

#ifndef MOLECULAR_TYPE_H
#include "Molecular_type.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef Array_H
#include "Array.h"
#endif

namespace MM
{

class Molecular_sequence_impl : public Molecular_sequence
{
    Model &                                             model_;
    Array <Molecular_type>                              type_;

public:
    explicit                        Molecular_sequence_impl (Model & model);

    virtual void                    reset (Model_event::Hint);

    virtual Molecular_type &        type  (int i)       {return type_[i];}
    virtual Molecular_type const &  type  (int i) const {return type_[i];}
    virtual int                     count () const      {return type_.size ();}

private:
    bool                    has_the_same_type (Molecule const & first_mol,
                                               Molecule const & second_mol);
};

}//MM

#endif //MOLECULAR_SEQUENCE_IMPL_H
