#include "Molecular_width_iterator.h"

#include "Atom.h"
#include "Atom_kit.h"

namespace MM
{

Molecular_width_iterator::
Molecular_width_iterator (Atom & root_atom)
{
    root_atom.kit().flag().set (Atom_kit::molecular_mark);
    queue_.push (&root_atom);
}

Atom & Molecular_width_iterator::
current ()
{
    return *queue_.front ();
}

const Atom & Molecular_width_iterator::
current () const
{
    return *queue_.front ();
}

void Molecular_width_iterator::
next ()
{
    Atom *current_atom = queue_.front ();
    queue_.pop ();
    find_neighbours (current_atom);
}

bool Molecular_width_iterator::
is_valid ()
{
    return ! queue_.empty ();
}

void Molecular_width_iterator::
find_neighbours (Atom *current_atom)
{
    int count = current_atom->bound_count ();
    for (int i=0;  i<count;  ++i)
    {
        Atom *neighbour = & current_atom->bound (i);
        if (neighbour->kit().flag().is_not (Atom_kit::molecular_mark))
        {
            neighbour->kit().flag().set (Atom_kit::molecular_mark);
            queue_.push (neighbour);
        }
    }
}

}//MM
