#ifndef MOLECULE_H
#define MOLECULE_H

#ifndef DISJOINT_GROUP_OF_ATOMS_H
#include "Disjoint_group_of_atoms.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef ATOM_GROUP_H
#include "Atom_group.h"
#endif

#ifndef RESIDUE_GROUP_H
#include "Residue_group.h"
#endif

//#ifndef BOND_GROUP_H
//#include "Bond_group.h"
//#endif

#ifndef LIVING_FRAME_H
#include "Living_frame.h"
#endif

namespace MM
{
class Atom;
class Atom_group;
class Vector_3D;

class Molecule : public Living_frame, public Disjoint_group_of_atoms, public Residue_group
{
public:
    virtual Molecule *      clone () const =0;
    static Molecule  &      none();

    virtual Text const &    local_id     () const =0;
    virtual void            set_local_id (Text const &) const =0;

    //virtual bool            is_alive  () const  =0;
    //virtual void            set_alive (bool on )=0;

    virtual void            add_atom    (Atom & ref) =0;
    virtual void            remove_atom (Atom & ref) =0;
    virtual void            remove_dead_atoms () =0;

    //virtual void        add_bond (Bond & bond)   =0;
    //virtual void        remove_bond (Bond & ref) =0;

    virtual int             mm_type () const =0;
    virtual void            set_mm_type (int type) =0;

    virtual double          mass () const =0;

    enum Format {ASCII, HTML};
    virtual Text            molecular_formula (Format format = ASCII) const =0;

    virtual double          charge () const =0;

    //virtual int             residue_count () const =0;
    //virtual Residue &       residue (int n) =0;
    //virtual Residue const & residue (int n) const =0;
    virtual void            reset_residues() =0;
    virtual void            clear_local_ids () =0;

    virtual void            move   (Vector_3D const& movement) =0;  //fix move to Atom_group
    virtual void            rotate (Vector_3D const& around, double teta)=0;
};

}//MM

#endif //MOLECULE_H
