#include "Test.h"

#include "Log.h"

#include "Model.h"
#include "Molecule.h"
#include "Molecular_detector.h"
//#include "Molecular_depth_iterator.h"
//#include "Molecular_width_iterator.h"
//#include "Element.h"
#include "Create.h"
#include "Path.h"

namespace MM
{

class Molecule_test : public Test
{
    Molecule *link;
public:
    Molecule_test (const Text& suite_name) : Test (suite_name) { }

    void run()
    {
        test_molecular_formula();   count_tests();
    }

    void test_molecular_formula()
    {
        Own <Model>     model (prototype <Model> (). clone ());

        Text filename = Path::tests() + "C20.hin";
        model().load (filename);
        Molecular_detector detector (model());
        detector.execute ();

        TEST ("", model().molecule(0).molecular_formula() == "C20H42");

        filename = Path::tests() + "B_DNA_6.hin";
        model().load (filename);
        detector.execute ();

        // C60 H69 N21 O36 P6 60+69+21+36+6=192
        TEST ("", model().molecule(0).molecular_formula() == "C60H69N21O36P6");
        TEST ("", model().molecule(1).molecular_formula() == "C60H69N21O36P6");

        //log () << "\n" << model().molecule(0).molecular_formula() << "\n";
    }
};

Molecule_test test_molecule ("correctness");

}//MM
