#ifndef OPENRM_BOND_H
#define OPENRM_BOND_H

#ifndef VISUAL_BOND_FRAME_H
#include "Visual_bond_frame.h"
#endif

extern "C" 
{
struct RMprimitive;
struct RMnode;
}

class OpenRMWidget;

namespace MM
{

class OpenRM_bond : public Visual_bond_frame
{
    RMnode                  *bond_node_;
    RMnode                  *parent_node_;
    OpenRMWidget            *rm_widget_;
    mutable bool            show_flag_;

    Visual_style            style_;

    RMnode *                wireframe_node_;
    RMprimitive *           line_;

    RMnode *                wireframe_CPK_node_;
    RMprimitive *           bi_line_;

    RMnode *                stick_node_;
    RMprimitive *           bi_cylinder_;

    RMnode *                ball_and_stick_node_;
    RMprimitive *           cylinder_;

public:
    explicit OpenRM_bond (Bond_kit &    kit, 
                          RMnode *      parent_node, 
                          OpenRMWidget *rm_widget);
    ~OpenRM_bond ();

    virtual Visual_bond *       clone (Bond_kit & kit) const;

    virtual void                show (bool on = true);
    virtual void                renew_view ();
    virtual void                renew_coordinates ();
    virtual void                renew_model ();
    virtual void                set_style (Visual_style const & );
    virtual void                renew ();

    void                        set_color (int R,  int G,  int B);

protected:
    void                        set_order ();
};

}//MM

#endif //OPENRM_BOND_H
