#include "Order.h"

#include "Flaw.h"

#include <string>

namespace MM
{
Order::
Order (const char r)
{
    detect (r);
}

Order::
Order (const char * r)
{
    using namespace std;
    string str (r);

    if (str.length() == 1)
    {
        detect (r[0]);
        return;
    }

    if (str == "Single")
        value_ = Single;

    else if (str == "Aromatic")
        value_ = Aromatic;

    else if (str == "Double")
        value_ = Double;

    else if (str == "Triple")
        value_ = Triple;

    else if (str == "Amide")
        value_ = Amide;

    else if (str == "Unknown")
        value_ = Unknown;

    else if (str == "Dummy")
        value_ = Dummy;

    else if (str == "No")
        value_ = No;
}

Order::
~Order ()
{
    value_ = No;
}

void Order::
detect (const char r)
{
    switch( r )
    {
        case 'A':
        case 'a':   value_ = Aromatic;  break;
        case 'S':
        case 's':   value_ = Single;    break;
        case 'D':
        case 'd':   value_ = Double;    break;
        case 'T':
        case 't':   value_ = Triple;    break;
        case 'M':
        case 'm':   value_ = Amide;     break;
        case 'U':
        case 'u':   value_ = Unknown;   break;
        case 'Y':
        case 'y':   value_ = Dummy;     break;
        case 'N':
        case 'n':   value_ = No;        break;

        default:  
        {
            FLAW("No such bond type.");
/*            char tmp[2]; tmp[0] = r;  tmp[1] = '\0';

            warning( "Order::Order( const char )\n"
                     "Can not convert '", tmp,"' to bond order.\n"
                     "Single bond order was assigned." );
            value_ = Single;//*/
        }
    }
}

const char * Order::
c_str() const
  { 
    switch( value_ )
      {
        case Aromatic:  return "Aromatic";
        case Single:    return "Single";
        case Double:    return "Double";
        case Triple:    return "Triple";
        case Amide:     return "Amide";
        case Unknown:   return "Unknown";
        case Dummy:     return "Dummy";
        case No:        return "No";
        default:        FLAW ("No such bond type.");
      }

    return "-"; 
  }

const char  Order::
c_char() const
  { 
    switch( value_ )
      {
        case Aromatic:  return 'a';
        case Single:    return 's';
        case Double:    return 'd';
        case Triple:    return 't';
        case Amide:     return 'm';
        case Unknown:   return 'u';
        case Dummy:     return 'y';
        case No:        return 'n';
        default:        FLAW("No such bond type.");
      }

    return '-'; 
  }

}//MM
