#ifndef ORDER_H
#define ORDER_H

namespace MM
{

class Order
{
public:
    enum Value {No       = -1,
                Aromatic =  0,
                Single   =  1,
                Double   =  2,
                Triple   =  3,
                Amide    =  4,
                Unknown  =  5,
                Dummy    =  6
                };//fix to HH

    const char * c_str  () const;
    const char   c_char () const;

    Order () : value_(Single) { }
    ~Order () ;

    Order (Value value) : value_(value) { }
    Order (const char);
    explicit Order (const char *);

    bool operator == (const Order &other) const {return value_ == other.value_;}
    bool operator != (const Order &other) const {return value_ != other.value_;}

private:
    Value       value_;

    void        detect (const char);
};

}//MM

#endif //ORDER_H
