#include "Pdb_C_alpha_atoms.h"

#include "Atom_kit.h"

namespace MM
{

Pdb_C_alpha_atoms::
Pdb_C_alpha_atoms (Atom_group & group)
{
    for (int i=0;  i<group.atom_count();  ++i)
    {
        Atom & current_atom = group.atom(i);

        if (current_atom.kit().has_pdb_attributes() &&
            current_atom.kit().pdb().name() == "CA")
        {
            group_.push_back (current_atom);

            if (current_atom.kit().has_visual())
                current_atom.kit().visual().show (true);
        }
        else
        {
            if (current_atom.kit().has_visual())
                current_atom.kit().visual().show (false);
        }
    }
}

}//MM
