#include "Pdb_backbone.h"

#include "Atom_kit.h"

namespace MM
{

Pdb_backbone::
Pdb_backbone (Atom_group & group)
{
    for (int i=0;  i<group.atom_count();  ++i)
    {
        Atom & current_atom = group.atom(i);

        if (current_atom.kit().has_pdb_attributes() &&
            current_atom.kit().pdb().name() == "CA" ||
            current_atom.kit().pdb().name() == "C"  ||
            current_atom.kit().pdb().name() == "N"  )
        {
            group_.push_back (current_atom);

            if (current_atom.kit().has_visual())
                current_atom.kit().visual().show (true);
        }
        else
        {
            if (current_atom.kit().has_visual())
                current_atom.kit().visual().show (false);
        }
    }
}

}//MM
