#ifndef RESIDUE_H
#define RESIDUE_H

#ifndef DISJOINT_GROUP_OF_ATOMS_H
#include "Disjoint_group_of_atoms.h"
#endif

#ifndef LIVING_FRAME_H
#include "Living_frame.h"
#endif

#ifndef JOINT_GROUP_H
#include "Joint_group.h"
#endif

namespace MM
{
class Text;

class Residue
:
    public Living_frame, public Disjoint_group_of_atoms, public Joint_group
{
public:
    static Residue &        none();

    //virtual Residue *       clone (Model &model) const =0;
    virtual Residue *       clone () const =0;

    virtual bool            has_name        () const  =0;
    virtual bool            has_short_alias () const  =0;
    virtual bool            has_alias       () const  =0;
    virtual bool            has_comment_line() const  =0;

    virtual Text const &    name         () const  =0;
    virtual Text const &    short_alias  () const  =0;
    virtual Text const &    alias        () const  =0;
    virtual Text const &    comment_line () const  =0;

    virtual void            set_name         (Text const & text)  =0;
    virtual void            set_short_alias  (Text const & text)  =0;
    virtual void            set_alias        (Text const & text)  =0;
    virtual void            set_comment_line (Text const & text)  =0;

    virtual Text const &    local_id     () const =0;
    virtual void            set_local_id (Text const &) const =0;
//    virtual Text const &    name () const =0;
    virtual void            add_atom (Atom & ref) =0;
    virtual void            remove_dead_atoms () =0;

    // Joint_group interface
    virtual void            add_joint (Joint &joint) =0;
    //virtual bool            has_left_joint      () const =0;
    //virtual bool            has_right_joint     () const =0;
    virtual Joint &         left_joint          () =0;
    virtual Joint &         right_joint         () =0;
    virtual void            remove_dead_joints  () =0;
};

}//MM

#endif //RESIDUE_H
