#ifndef RESIDUE_GROUP_IMPL_H
#define RESIDUE_GROUP_IMPL_H

#ifndef RESIDUE_GROUP_H
#include "Residue_group.h"
#endif

#ifndef RESIDUE_H
#include "Residue.h"
#endif

#include "Array_of_own.h"

namespace MM
{
class Residue_group_impl : public Residue_group
{
    Array_of_own <Residue>  residue_;

public:
    explicit Residue_group_impl (Atom_group &);

    int             residue_count () const          {return residue_.size();}
    Residue &       residue (int n)                 {return residue_[n];}
    Residue const & residue (int n) const           {return residue_[n];}
    void            remove_dead_residues ()         {residue_.stable_kill_deads();}
};

}//MM

#endif //RESIDUE_GROUP_IMPL_H
