#ifndef SELECTED_ATOMS_H
#define SELECTED_ATOMS_H

#ifndef ATOM_GROUP_H
#include "Atom_group.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{

class Selected_atoms : public Atom_group
{
    Array_of_ref <Atom>     group_;

public:
    explicit                Selected_atoms (Atom_group & group);

    virtual int             atom_count () const     {return group_.size();}
    virtual Atom &          atom (int i)            {return group_[i];}
    virtual const Atom &    atom (int i) const      {return group_[i];}
};

}//MM

#endif //SELECTED_ATOMS_H
