#ifndef VISUAL_BOND_H
#define VISUAL_BOND_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef VISUAL_STYLE_H
#include "Visual_style.h"
#endif

namespace MM
{
//class Visual_bond_type;
class Bond_kit;

class Visual_bond : protected DbC
{
public:                //
    enum Type {wireframe, wireframe_CPK, stick};

    virtual Visual_bond *       clone (Bond_kit & kit) const=0;

    virtual Bond_kit &          kit () =0;
    virtual Bond_kit const &    kit () const =0;

    virtual void                show (bool on = true) =0;
    virtual void                renew_view () =0;
    virtual void                renew_coordinates () =0;
    virtual void                renew_model () =0;
    virtual void                renew () =0;

    virtual void                set_color (int R,  int G,  int B)=0;
    virtual void                set_style (Visual_style const &) =0;
};

}//MM

#endif //VISUAL_BOND_H
