#include "Visual_bond_composite.h"

namespace MM
{

Visual_bond * Visual_bond_composite::
clone (Bond_kit & kit) const
{
    Visual_bond_composite *result = new Visual_bond_composite (kit);

    for (int i=0;  i<count();  ++i)
        result->adopt (visual_[i].clone (kit));

    return result;
}

void Visual_bond_composite::
adopt (Visual_bond * adoptee)
{
    visual_.push_back (adoptee);
}

void Visual_bond_composite::
show (bool on)
{
    for (int i=0;  i<count();  ++i)
        visual_[i].show (on);
}

void Visual_bond_composite::
renew_view ()
{
    for (int i=0;  i<count();  ++i)
        visual_[i].renew_view ();
}

void Visual_bond_composite::
renew_coordinates ()
{
    for (int i=0;  i<count();  ++i)
        visual_[i].renew_coordinates ();
}

void Visual_bond_composite::
renew_model ()
{
    for (int i=0;  i<count();  ++i)
        visual_[i].renew_model ();
}

void Visual_bond_composite::
renew ()
{
    renew_view ();
    renew_coordinates ();
    renew_model ();
}

void Visual_bond_composite::
set_color (int R,  int G,  int B)
{
    for (int i=0;  i<count();  ++i)
        visual_[i].set_color (R, G, B);
}

void Visual_bond_composite::
set_style (Visual_style const & style)
{
    for (int i=0;  i<count();  ++i)
        visual_[i].set_style (style);
}

}//MM
