#ifndef VISUAL_BOND_COMPOSITE_H
#define VISUAL_BOND_COMPOSITE_H

#ifndef VISUAL_BOND_H
#include "Visual_bond.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

namespace MM
{

class Visual_bond_composite : public Visual_bond
{
    Bond_kit &                  kit_;
    Array_of_own <Visual_bond>  visual_;

public:
    explicit Visual_bond_composite (Bond_kit & kit) : kit_(kit) {}
    virtual Visual_bond *       clone (Bond_kit & kit) const;

    int                         count () const          {return visual_.size();}
    Visual_bond &               view (int i)            {return visual_[i];}
    Visual_bond const &         view (int i) const      {return visual_[i];}
    void                        adopt (Visual_bond * adoptee);

    Bond_kit &                  kit ()                  {return kit_;}
    Bond_kit const &            kit () const            {return kit_;}

    void                        show (bool on = true);
    void                        renew_view ();
    void                        renew_coordinates ();
    void                        renew_model ();
    void                        renew ();
    void                        set_color (int R,  int G,  int B);
    void                        set_style (Visual_style const & );
};

}//MM

#endif //VISUAL_BOND_COMPOSITE_H
