#ifndef ARRAY_OF_OBJ_H
#define ARRAY_OF_OBJ_H

#ifndef ARRAY_OF_H
#include "Array_of.h"
#endif

#ifndef ARRAY_H
#include "Array.h"
#endif

namespace MM
{

template <class T>
class Array_of_obj : public Array_of <T>
{
    Array <T>           impl_;

public:
    virtual int         size ()            const    {return impl_.size();}
    virtual T &         operator[] (int i)          {return impl_[i];}
    virtual const T &   operator[] (int i) const    {return impl_[i];}

    virtual  T &        front()                     {return impl_.front();}
    virtual const T &   front() const               {return impl_.front();}
    virtual T &         back()                      {return impl_.back();}
    virtual const T &   back() const                {return impl_.back();}

    virtual void        push_back (const T & item)  {impl_.push_back( item );}

    void                put (int index, const T & item) {impl_[ index ] = item;}
    void                remove_at (int index)       {impl_.remove_at (index);}

    void                remove (T & item)
    {
        for (int i = 0;  i < size();  ++i)
            if (&impl_[i] == &item)
            {
                impl_.remove_at (i);
                return;
            }
        FLAW ("No such reference.");
    }

    void                clear()                     {impl_.clear();}
};

}//MM

#endif //ARRAY_OF_OBJ_H

