#include "Hyperchem_atoms.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"
#include "Hyperchem_attributes.h"

namespace MM
{

Hyperchem_atoms::Hyperchem_atoms (Atom_group & group)
{
    for (int i=0;  i<group.atom_count();  ++i)
    {
        if (! group.atom(i).kit().has_hyperchem_attributes())
        {
            Hyperchem_attributes * new_attributes 
                = new Hyperchem_attributes (group.atom(i));
            group.atom(i).kit().add_hyperchem_attributes( new_attributes );
        }
        group.atom(i).kit().hyperchem().set_number( i );
        push_back (group.atom(i));
    }
}

}//MM
