#ifndef LIVING_H
#define LIVING_H

namespace MM
{

class Living
{
public:
    virtual                ~Living     () { }
    virtual void            release     (void * context) =0;
    virtual void            kill        () =0;
    virtual void *          owner       () =0;
    virtual void const *    owner       () const =0;
    virtual void            set_owner   (void * owner) =0;

    //virtual bool            is_flywight () const =0;
    virtual bool            is_alive    () const =0;
    virtual bool            is_dead     () const =0;
    virtual void            set_dead    (bool kill = true) =0;
};

template <typename T>
int remove_deads (T begin, T end)
{
    int removed = 0;

    while (begin != end)
    {
        while ((*begin)->is_dead())
        {
            ++removed;
            *begin = *(--end);

            if (begin == end) 
                return removed;
        }
        ++begin;
    }
    return removed;
}

template<typename T, typename V> inline
T stable_remove(T begin, T end, const V & value)
{
    T current = begin;

    for (int i=0;  i<end - begin;  ++i)
    {
        if (!(*(begin + i) == value))
            *current++ = *(begin + i);
    }

    return current;
}

template <typename T>
int kill_deads (T begin, T end)
{
    int removed = 0;

    while (begin != end)
    {
        while ((*begin)->is_dead())
        {
            (*begin)->kill();
            ++removed;
            *begin = *(--end);

            if (begin == end) 
                return removed;
        }
        ++begin;
    }
    return removed;
}

}//MM

#endif //LIVING_H
