#ifndef LIVING_FRAME_H
#define LIVING_FRAME_H

#ifndef LIVING_H
#include "Living.h"
#endif

namespace MM
{

class Living_frame : public Living
{
    void *          owner_;
    bool            is_dead_;

public:
    explicit Living_frame (void * owner=0) : owner_(owner), is_dead_(false) {}

    void            release (void * context)
    {
        if (owner_ == 0 || context == owner_)
            delete this;
    }

    void            kill () {release (owner_);}
    void *          owner       ()                  {return owner_;}
    void const *    owner       () const            {return owner_;}
    void            set_owner   (void * owner)      {owner_ = owner;}

//    bool            is_flywight () const    {return false;}
    bool            is_alive    () const    {return !is_dead_;}
    bool            is_dead     () const    {return  is_dead_;}
    void            set_dead    (bool kill = true) {is_dead_ = kill;}
};

}//MM

#endif //LIVING_FRAME_H
