#include "Pdb_atoms.h"

#include "Pdb_attributes.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "Atom_group.h"

namespace MM
{

Pdb_atoms::Pdb_atoms (Atom_group & group)
{
    for( int i=0;  i<group.atom_count();  ++i )
    {
        if( ! group.atom(i).kit().has_pdb_attributes() )
        {
            FIX; //no default name in Pdb_attributes
            Pdb_attributes * new_attributes = new Pdb_attributes;
            group.atom(i).kit().add_pdb_attributes( new_attributes );
        }
        group.atom(i).kit().pdb().set_number( i );
        push_back( group.atom(i) );
    }
}

}//MM
