#ifndef MODULE_H
#define MODULE_H

#ifdef MM_WIN32
#pragma warning (disable : 4786)
#endif

#ifndef MODULE_VOID_HANDLE_H
#include "Module_void_handle.h"
#endif

#ifndef MODULE_BOOL_HANDLE_H
#include "Module_bool_handle.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

namespace MM
{

class Module
{
    Text                                name_;
    Array_of_own <Command>              command_;
    Array_of_own <Command_1 <bool> >    command_bool_;

public:        
    explicit            Module   (Text const & name);
    virtual            ~Module   () {}
    virtual void        init     () =0;
    static void         init_all ();
    Text const &        name     () const               {return name_;}

protected:
    Module_void_handle  adopt_command (Command * cmd);
    Module_bool_handle  adopt_command (Command_1 <bool> * cmd);
    void                insert_menu_separator (Text const& menu);

    friend Module_void_handle::~Module_void_handle ();
    friend Module_bool_handle::~Module_bool_handle ();
    void adopt (Command * adoptee)          {command_.push_back (adoptee);}
    void adopt (Command_1 <bool> * adoptee) {command_bool_.push_back (adoptee);}
};

}//MM

#endif //MODULE_H
