#ifndef MODULE_BOOL_HANDLE_H
#define MODULE_BOOL_HANDLE_H

#ifndef MODULE_HANDLE_H
#include "Module_handle.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

namespace MM
{

class Module_bool_handle : public Module_handle
{
    Own <Command_1 <bool> >     command_bool_;
    bool                        check_;

public:
    Module_bool_handle (Module & module, Command_1 <bool> * adoptee)
        : Module_handle (module), command_bool_(adoptee), check_(false)
    {
    }

   ~Module_bool_handle ()   ;

    Module_handle & set_menu (char const * menu, char const * item, bool check)
        {menu_ = menu;   menu_item_ = item;   check_ = check;  return *this;}

    bool            checked () {return check_;}

    Own <Command_1 <bool> > &   command () {return command_bool_;}
};

}//MM

#endif //MODULE_BOOL_HANDLE_H
