#ifndef MODULE_HANDLE_H
#define MODULE_HANDLE_H

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

namespace MM
{
class Module;

class Module_handle
{
protected:
    Module &                    module_;
    Text                        menu_;
    Text                        menu_item_;
    Text                        accelerator_;
    Text                        tool_bar_;
    Text                        icon_;
    Text                        tool_tip_;

public:
    explicit                Module_handle (Module & module) : module_(module) {}
    virtual                ~Module_handle () =0;

    Text const &            module_name () const;
    char const *            menu        () const  {return menu_       .c_str();}
    char const *            menu_item   () const  {return menu_item_  .c_str();}
    char const *            accelerator () const  {return accelerator_.c_str();}
    char const *            tool_bar    () const  {return tool_bar_   .c_str();}
    char const *            icon        () const  {return icon_       .c_str();}
    char const *            tool_tip    () const  {return tool_tip_   .c_str();}

    bool        has_menu        () const  {return menu_       .size() != 0;}
    //bool        has_menu_item   () const  {return menu_item_  .size() != 0;}
    bool        has_accelerator () const  {return accelerator_.size() != 0;}
    bool        has_icon        () const  {return icon_       .size() != 0;}
    bool        has_tool_tip    () const  {return tool_tip_   .size() != 0;}

    Module_handle & set_menu
        (char const * menu, char const * item, bool stub = false)
        {menu_ = menu;   menu_item_ = item; stub; return *this;}

    Module_handle & set_accelerator (char const * shortcut)
        {accelerator_ = shortcut; return *this;}

    Module_handle & set_icon (char const * tool_bar, char const * file) 
        {tool_bar_ = tool_bar; icon_ = file; return *this;}

    Module_handle & set_tool_tip (char const * tool_tip)
        {tool_tip_ = tool_tip; return *this;}
};

}//MM

#endif //MODULE_HANDLE_H
