#include "Test_module.h"

#include "Command_template.h"
#include "Test_suite.h"

//#include "Peep.h"

//#undef NDEBUG

namespace MM
{

Test_module  Test_module::singleton_;

Test_module::Test_module () : Module ("Test") { }

void Test_module::
init ()
{
    //Peep().execute();

    adopt_command (create_command (*this, &Test_module::test_correctness))
        .set_accelerator ("Ctrl+t")
#ifndef NDEBUG
        .set_menu ("&Test", "&Correctness")
#endif
        ;

#ifndef NDEBUG
    adopt_command (create_command (*this, &Test_module::test_performance))
        .set_menu ("&Test", "&Performance");

    adopt_command (create_command (*this, &Test_module::test_demo))
        .set_menu ("&Test", "&Demo");

    adopt_command (create_command (*this, &Test_module::test_temporary))
        .set_menu ("&Test", "&Temporary");

    insert_menu_separator ("&Test");

    adopt_command (create_command (*this, &Test_module::test_all))
        //.set_separator   ()
        .set_menu ("&Test", "&All");
#endif
}

void Test_module::
test_correctness ()
{
    Test_suite::singleton ("correctness"). run();
    //Test_suite::singleton ("correctness"). mix();
    //Test_suite::singleton ("correctness"). run();
    Test_suite::singleton ("correctness"). sort();
    Test_suite::singleton ("correctness"). run();
}

void Test_module::
test_performance ()
{
    Test_suite::singleton ("performance"). run();
}

void Test_module::
test_demo ()
{
    Test_suite::singleton ("demo"). run();
}

void Test_module::
test_temporary ()
{
    Test_suite::singleton ("temporary"). run();
}

void Test_module::
test_all ()
{
    Test_suite::run_all();
}

}//MM
