#ifndef COMMAND_H
#define COMMAND_H

namespace MM
{

class Command
{
public:    
    virtual void execute () =0;
    virtual ~Command() { }
};

template <typename Arg1>
class Command_1
{
public:    
    virtual void execute (Arg1 arg1) =0;
    virtual ~Command_1() { }
};

template <typename Arg1, typename Arg2>
class Command_2
{
public:    
    virtual void execute (Arg1 arg1, Arg2 arg2) =0;
    virtual ~Command_2() { }
};

template <typename Arg1, typename Arg2, typename Arg3>
class Command_3
{
public:    
    virtual void execute (Arg1 arg1, Arg2 arg2, Arg3 arg3) =0;
    virtual ~Command_3() { }
};

class No_command : public Command
{
public:    
    virtual void execute () {;}
};


}//MM

#endif //COMMAND_H
