#ifndef APPLICATION_H
#define APPLICATION_H

#include <queue>

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif


namespace MM
{

class Application : protected DbC
{
protected:
    std::queue <Command*>   task_;

public:
    virtual Text const &    name () const =0;
    virtual void            init ()=0;
    virtual int             run  ()=0;

    void                    adopt_task (Command * adoptee){task_.push(adoptee);}
};

}//MM

#endif //APPLICATION_H
