#include "Common_configuration.h"

#include "Prototype_repository.h"

#include "Default_id.h"

#include "Atom_impl.h"
#include "Default_bond.h"
#include "Distance_restraint.h"
#include "Residue_impl.h"
#include "Joint.h"
#include "Molecule_impl.h"
#include "Model_impl.h"
#include "Add_builder_impl.h"

#include "Create.h"

#include <locale.h>

namespace MM
{

Common_configuration::
Common_configuration ()
{
    //setlocale (LC_ALL, ".ACP");
    //setlocale (LC_NUMERIC, "");
    setlocale (LC_ALL, "");
    setlocale (LC_NUMERIC, "C");

    Prototype_repository & repository = Prototype_repository::singleton();
    Prototype prototype;

    repository.adopt ((ID*)                 new Default_id());

    Atom_impl *atom = new Atom_impl (Element("C"));
    atom->kit().add_hyperchem_attributes (new Hyperchem_attributes(*atom)); //fix
    repository.adopt ((Atom*) atom);

    repository.adopt ((Bond*)               new Default_bond (prototype));
    repository.adopt ((Distance_restraint*) new Distance_restraint (prototype));
    repository.adopt ((Residue*)            new Residue_impl ());
    repository.adopt ((Joint*)              new Joint (prototype));
    repository.adopt ((Molecule*)           new Molecule_impl ());

    repository.adopt ((Model*)              new Model_impl (prototype));

    repository.adopt ((Add_builder*)        new Add_builder_impl (prototype));

}

}//MM
